% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toeplitz.R
\name{toep}
\alias{toep}
\title{Toeplitz Approximation Problem}
\usage{
toep(A)
}
\arguments{
\item{A}{A symmetric matrix}
}
\value{
Returns an object of class sqlp_input, containing the following:

\item{blk}{A matrix object describing the block diagonal structure of the SQLP data}
\item{At}{A matrix object containing constraint matrices for the primal-dual problem}
\item{C}{A matrix object containing the constant c matrices in the primal objective function}
\item{b}{A vector containing the right hand side of the equality constraints in the primal problem}
\item{OPTIONS}{A list object specifying the value of parbarrier}
}
\description{
\code{toep} creates input for sqlp to solve the Toeplitz approximation problem -
given a symmetric matrix F, find the nearest symmetric positive definite Toeplitz matrix.
}
\details{
For a symmetric matrix A, determines the closest Toeplitz matrix. Mathematical and implementation
details can be found in the vignette
}
\examples{
data(Ftoep)

out <- toep(Ftoep)
blk <- out$blk
At <- out$At
C <- out$C
b <- out$b

}

