% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpp.R
\name{gpp}
\alias{gpp}
\title{Graph Partitioning Problem}
\usage{
gpp(B, alpha)
}
\arguments{
\item{B}{A weighted adjacency matrix}

\item{alpha}{Any real value in (0,n^2)}
}
\value{
\item{X}{A list containing the solution matrix to the primal problem}
\item{y}{A list containing the  solution vector to the dual problem}
\item{Z}{A list containing the  solution matrix to the dual problem}
\item{pobj}{The achieved value of the primary objective function}
\item{dobj}{The achieved value of the dual objective function}
}
\description{
\code{gpp} creates input for sqlp to solve the graph partitioning problem.
}
\details{
Solves the graph partitioning problem. Mathematical and implementation
details can be found in the vignette
}
\examples{
data(Bgpp)
alpha <- nrow(Bgpp)

out <- gpp(Bgpp, alpha)

}
