% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hardcode.R
\name{harcode}
\alias{harcode}
\alias{hardcode_no_ct}
\alias{hardcode_ct}
\title{Derive an SDTM variable with a hardcoded value}
\usage{
hardcode_no_ct(
  tgt_dat = NULL,
  tgt_val,
  raw_dat,
  raw_var,
  tgt_var,
  id_vars = oak_id_vars()
)

hardcode_ct(
  tgt_dat = NULL,
  tgt_val,
  raw_dat,
  raw_var,
  tgt_var,
  ct_spec,
  ct_clst,
  id_vars = oak_id_vars()
)
}
\arguments{
\item{tgt_dat}{Target dataset: a data frame to be merged against \code{raw_dat} by
the variables indicated in \code{id_vars}. This parameter is optional, see
section Value for how the output changes depending on this argument value.}

\item{tgt_val}{The target SDTM value to be hardcoded into the variable
indicated in \code{tgt_var}.}

\item{raw_dat}{The raw dataset (dataframe); must include the
variables passed in \code{id_vars} and \code{raw_var}.}

\item{raw_var}{The raw variable: a single string indicating the name of the
raw variable in \code{raw_dat}.}

\item{tgt_var}{The target SDTM variable: a single string indicating the name
of variable to be derived.}

\item{id_vars}{Key variables to be used in the join between the raw dataset
(\code{raw_dat}) and the target data set (\code{raw_dat}).}

\item{ct_spec}{Study controlled terminology specification: a dataframe with a
minimal set of columns, see \code{\link[=ct_spec_vars]{ct_spec_vars()}} for details. This parameter is
optional, if left as \code{NULL} no controlled terminology recoding is applied.}

\item{ct_clst}{A codelist code indicating which subset of the controlled
terminology to apply in the derivation. This parameter is optional, if left
as \code{NULL}, all possible recodings in \code{ct_spec} are attempted.}
}
\value{
The returned data set depends on the value of \code{tgt_dat}:
\itemize{
\item If no target dataset is supplied, meaning that \code{tgt_dat} defaults to
\code{NULL}, then the returned data set is \code{raw_dat}, selected for the variables
indicated in \code{id_vars}, and a new extra column: the derived variable, as
indicated in \code{tgt_var}.
\item If the target dataset is provided, then it is merged with the raw data set
\code{raw_dat} by the variables indicated in \code{id_vars}, with a new column: the
derived variable, as indicated in \code{tgt_var}.
}
}
\description{
\itemize{
\item \code{\link[=hardcode_no_ct]{hardcode_no_ct()}} maps a hardcoded value to a target SDTM variable that has
no terminology restrictions.
\item \code{\link[=hardcode_ct]{hardcode_ct()}} maps a hardcoded value to a target SDTM variable with
controlled terminology recoding.
}
}
\examples{
md1 <-
  tibble::tribble(
    ~oak_id, ~raw_source, ~patient_number, ~MDRAW,
    1L,      "MD1",       101L,            "BABY ASPIRIN",
    2L,      "MD1",       102L,            "CORTISPORIN",
    3L,      "MD1",       103L,            NA_character_,
    4L,      "MD1",       104L,            "DIPHENHYDRAMINE HCL"
  )

# Derive a new variable `CMCAT` by overwriting `MDRAW` with the
# hardcoded value "GENERAL CONCOMITANT MEDICATIONS".
hardcode_no_ct(
  tgt_val = "GENERAL CONCOMITANT MEDICATIONS",
  raw_dat = md1,
  raw_var = "MDRAW",
  tgt_var = "CMCAT"
)

cm_inter <-
  tibble::tribble(
    ~oak_id, ~raw_source, ~patient_number, ~CMTRT,                ~CMINDC,
    1L,      "MD1",       101L,            "BABY ASPIRIN",        NA,
    2L,      "MD1",       102L,            "CORTISPORIN",         "NAUSEA",
    3L,      "MD1",       103L,            "ASPIRIN",             "ANEMIA",
    4L,      "MD1",       104L,            "DIPHENHYDRAMINE HCL", "NAUSEA",
    5L,      "MD1",       105L,            "PARACETAMOL",         "PYREXIA"
  )

# Derive a new variable `CMCAT` by overwriting `MDRAW` with the
# hardcoded value "GENERAL CONCOMITANT MEDICATIONS" with a prior join to
# `target_dataset`.
hardcode_no_ct(
  tgt_dat = cm_inter,
  tgt_val = "GENERAL CONCOMITANT MEDICATIONS",
  raw_dat = md1,
  raw_var = "MDRAW",
  tgt_var = "CMCAT"
)

# Controlled terminology specification
(ct_spec <- read_ct_spec_example("ct-01-cm"))

# Hardcoding of `CMCAT` with the value `"GENERAL CONCOMITANT MEDICATIONS"`
# involving terminology recoding. `NA` values in `MDRAW` are preserved in
# `CMCAT`.
hardcode_ct(
  tgt_dat = cm_inter,
  tgt_var = "CMCAT",
  raw_dat = md1,
  raw_var = "MDRAW",
  tgt_val = "GENERAL CONCOMITANT MEDICATIONS",
  ct_spec = ct_spec,
  ct_clst = "C66729"
)

}
