% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hardcode.R
\name{sdtm_hardcode}
\alias{sdtm_hardcode}
\title{Derive an SDTM variable with a hardcoded value}
\usage{
sdtm_hardcode(
  tgt_dat = NULL,
  tgt_var,
  raw_dat,
  raw_var,
  tgt_val,
  ct_spec = NULL,
  ct_clst = NULL,
  id_vars = oak_id_vars()
)
}
\arguments{
\item{tgt_dat}{Target dataset: a data frame to be merged against \code{raw_dat} by
the variables indicated in \code{id_vars}. This parameter is optional, see
section Value for how the output changes depending on this argument value.}

\item{tgt_var}{The target SDTM variable: a single string indicating the name
of variable to be derived.}

\item{raw_dat}{The raw dataset (dataframe); must include the
variables passed in \code{id_vars} and \code{raw_var}.}

\item{raw_var}{The raw variable: a single string indicating the name of the
raw variable in \code{raw_dat}.}

\item{tgt_val}{The target SDTM value to be hardcoded into the variable
indicated in \code{tgt_var}.}

\item{ct_spec}{Study controlled terminology specification: a dataframe with a
minimal set of columns, see \code{\link[=ct_spec_vars]{ct_spec_vars()}} for details. This parameter is
optional, if left as \code{NULL} no controlled terminology recoding is applied.}

\item{ct_clst}{A codelist code indicating which subset of the controlled
terminology to apply in the derivation. This parameter is optional, if left
as \code{NULL}, all possible recodings in \code{ct_spec} are attempted.}

\item{id_vars}{Key variables to be used in the join between the raw dataset
(\code{raw_dat}) and the target data set (\code{tgt_dat}).}
}
\value{
The returned data set depends on the value of \code{tgt_dat}:
\itemize{
\item If no target dataset is supplied, meaning that \code{tgt_dat} defaults to
\code{NULL}, then the returned data set is \code{raw_dat}, selected for the variables
indicated in \code{id_vars}, and a new extra column: the derived variable, as
indicated in \code{tgt_var}.
\item If the target dataset is provided, then it is merged with the raw data set
\code{raw_dat} by the variables indicated in \code{id_vars}, with a new column: the
derived variable, as indicated in \code{tgt_var}.
}
}
\description{
\code{\link[=sdtm_hardcode]{sdtm_hardcode()}} is an internal function packing the same functionality as
\code{\link[=hardcode_no_ct]{hardcode_no_ct()}} and \code{\link[=hardcode_ct]{hardcode_ct()}} together but aimed at developers only.
As a user please use either \code{\link[=hardcode_no_ct]{hardcode_no_ct()}} or \code{\link[=hardcode_ct]{hardcode_ct()}}.
}
\keyword{internal}
