% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{lambda_max}
\alias{lambda_max}
\alias{lambda_max_fitted_group_lasso}
\alias{lambda_max_group_lasso}
\alias{lambda_max_lasso}
\alias{lambda_max_sparse_group_lasso}
\title{Maximal \eqn{\lambda}}
\usage{
lambda_max_fitted_group_lasso(
  DELTA,
  VECTOR_Y,
  VECTOR_GROUPS,
  VECTOR_WEIGHTS_FEATURES,
  VECTOR_WEIGHTS_GROUPS,
  VECTOR_FULL_COLUMN_RANK,
  VECTOR_BETA,
  MATRIX_X
)

lambda_max_group_lasso(
  VECTOR_Y,
  VECTOR_GROUPS,
  VECTOR_WEIGHTS_FEATURES,
  VECTOR_BETA,
  MATRIX_X
)

lambda_max_lasso(VECTOR_Y, VECTOR_WEIGHTS_FEATURES, VECTOR_BETA, MATRIX_X)

lambda_max_sparse_group_lasso(
  ALPHA,
  VECTOR_Y,
  VECTOR_GROUPS,
  VECTOR_WEIGHTS_FEATURES,
  VECTOR_BETA,
  MATRIX_X
)
}
\arguments{
\item{DELTA}{numeric value, which is squared and added to the main diagonal
of \eqn{Z^{(l)T} Z^{(l)}} for group l, if this matrix is not invertible.}

\item{VECTOR_Y}{numeric vector of observations.}

\item{VECTOR_GROUPS}{integer vector specifying which effect (fixed and
random) belongs to which group.}

\item{VECTOR_WEIGHTS_FEATURES}{numeric vector of weights for the vectors of
fixed and random effects \eqn{[b^T, u^T]^T}.}

\item{VECTOR_WEIGHTS_GROUPS}{numeric vector of pre-calculated weights for
each group.}

\item{VECTOR_FULL_COLUMN_RANK}{Boolean vector, which harbors the information
of whether or not the group-wise parts of the filtered matrix Z, i.e.,
\eqn{Z^{(l)}} for each group l, have full column rank.}

\item{VECTOR_BETA}{numeric vector of features. At the end of this function,
the random effects are initialized with zero, but the fixed effects are
initialized via a least squares procedure.}

\item{MATRIX_X}{numeric design matrix relating y to fixed and random
effects \eqn{[X Z]}.}

\item{ALPHA}{mixing parameter of the penalty terms. Satisfies: \eqn{0 <
\alpha < 1}. The penalty term looks as follows: \deqn{\alpha *
"lasso penalty" + (1-\alpha) * "group lasso penalty".}}
}
\value{
the maximum value for the penalty parameter \eqn{\lambda}.
}
\description{
An effective grid search for the lasso variants is based on
starting with a maximal value for the penalty parameter \eqn{\lambda}. This
is due to ability of the lasso variants to select features. The idea is to
determine a value of \eqn{\lambda} such that any further increase of this
value simply results in a solution with no selection (apart from fixed
effects).
}
\details{
The value is calculated under the following prerequisites: The
algorithm shall converge after a single iteration and the solution shall be
equal to the initial solution. Additionally, the converged solution shall be
zero for all random effects (which corresponds to "no selection".) The
estimates for fixed effects shall simply remain unchanged after one
iteration. Due to the explicit formulas of the proximal gradient descent
algorithm, this naturally leads to a set of values for \eqn{\lambda} which
guarantee to meet all the mentioned requirements. The lower bound of this
set is then \eqn{\lambda_{max}}.

Particularly for the sparse-group lasso, the calculation involves to find
the positive root of a non-trivial polynomial of second degree. In order to
solve this, an additional bisection algorithm is implemented. (See:
\code{\link[seagull]{seagull_bisection}}.)
}
