% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/searchable-package.R
\docType{package}
\name{searchable-package}
\alias{searchable-package}
\title{searchable}
\description{
Make R objects more searchable by allowing search of names based on case
(in)sensitivity, regular expressions, fixed patterns, exact matches, etc.
The package facilitates making and searching dictionaries,
}
\examples{
# ATOMIC VECTORS
    v <- c( ay=1, bee=2, cee=3 )
    sv <- searchable( v, ignore.case  )

    sv$BEE

    sv[[ "b" ]]                # 2
    sv[[ "B" ]]                # 2
    sv[[ ignore.case('BEE') ]] # 2

    sv[[ fixed('b') ]]         # 2


    sv[ 'bee' ]
    sv[ 'ee' ]                 #
    sv[ perl('[A|B]') ]        # 1,2

  # RECURSIVE LISTS

    l <- list( ay=c(1), bee=c(2), cee=3 )
    sl <- searchable(l, ignore.case )

    sl$BEE                     # 1 2

    sl[[ "b" ]]                # 1 2
    sl[[ "B" ]]                # 1 2
    sl[[ ignore.case('BEE') ]] # 1 2

    sl[[ fixed('b') ]]         # 1 2

    sl[ 'bee' ]
    sl[ 'ee' ]                 # 1  1 2
    sl[ perl('[a|b]') ]        # 1  1 2
}
\references{
\url{http://stackoverflow.com/questions/5671719/case-insensitive-search-of-a-list-in-r} \cr
}
\seealso{
\code{\link{searchable}}
}

