% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base.R
\name{sha3}
\alias{sha3}
\alias{sha3file}
\title{Cryptographic Hashing Using the SHA-3 Algorithm}
\usage{
sha3(x, bits = 256L, convert = TRUE)

sha3file(file, bits = 256L, convert = TRUE)
}
\arguments{
\item{x}{R object to hash. A character string or raw vector (without
attributes) is hashed 'as is'. All other objects are hashed using R
serialization in a memory-efficient 'streaming' manner, without
allocation of the serialized object. To ensure portability, serialization
v3 XDR is always used with headers skipped (as these contain R version
and encoding information).}

\item{bits}{[default 256L] output size of the returned hash. If one of 224,
256, 384 or 512, uses the relevant SHA-3 cryptographic hash function. For
all other values, uses the SHAKE256 extendable-output function (XOF).
Must be between 8 and 2^24 and coercible to integer.}

\item{convert}{[default TRUE] if TRUE, the hash is converted to its hex
representation as a character string, if FALSE, output directly as a raw
vector, or if NA, a vector of (32-bit) integer values.}

\item{file}{character file name / path. The file is hashed in a streaming
fashion and does not need to fit in memory.}
}
\value{
A character string, raw or integer vector depending on 'convert'.
}
\description{
Returns a SHA-3 hash of the supplied R object or file.
}
\details{
To produce single integer values suitable for use as random seeds
    for R's pseudo random number generators (RNGs), set 'bits' to 32 and
    'convert' to NA.
}
\examples{
# SHA3-256 hash as character string:
sha3("secret base")

# SHA3-256 hash as raw vector:
sha3("secret base", convert = FALSE)

# SHA3-224 hash as character string:
sha3("secret base", bits = 224)

# SHA3-384 hash as character string:
sha3("secret base", bits = 384)

# SHA3-512 hash as character string:
sha3("secret base", bits = 512)

# SHAKE256 hash to integer:
sha3("secret base", bits = 32L, convert = NA)

# SHA3-256 hash a file:
file <- tempfile(); cat("secret base", file = file)
sha3file(file)
unlink(file)
    
}
