% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotPFMs.R
\name{PlotPFMs}
\alias{PlotPFMs}
\title{Plot forward modelled sedimentary proxies}
\usage{
PlotPFMs(
  PFMs,
  stage.order = c("var", "seq"),
  plot.stages = c("default"),
  max.replicates = 5,
  colr.palette = "default",
  alpha.palette = "default",
  levl.labels = "default"
)
}
\arguments{
\item{PFMs}{A dataframe of forward modelled proxies}

\item{stage.order}{Controls the order in which proxy stages are plotted,
either sequentially, "seq", or in order of variance, "var". Defaults to var.}

\item{plot.stages}{Proxy stages to be plotted, "default", "all", or a custom character vector}

\item{max.replicates}{Maximum number of replicates to plot at once}

\item{colr.palette}{Colours for the proxy stages}

\item{alpha.palette}{Alpha levels for the proxy stages}

\item{levl.labels}{Labels for the proxy stages}
}
\value{
a ggplot object of class "gg" "ggplot"
}
\description{
Plot forward modelled sedimentary proxies
}
\examples{
library(ggplot2)
set.seed(26052017)
clim.in <- ts(N41.t21k.climate[nrow(N41.t21k.climate):1,] - 273.15)

PFM <- ClimToProxyClim(clim.signal = clim.in,
                       timepoints = round(N41.proxy$Published.age),
                       calibration.type = "identity",
                       habitat.weights = N41.G.ruber.seasonality,
                       sed.acc.rate = N41.proxy$Sed.acc.rate.cm.ka,
                       sigma.meas = 0.45,
                       sigma.ind = 0,
                       n.samples = Inf,
                       plot.sig.res = 10, meas.bias = 1,
                       n.replicates = 10)

PlotPFMs(PFM$everything, max.replicates = 1, stage.order = "seq") +
  facet_wrap(~stage)

PlotPFMs(PFM$everything, max.replicates = 1, stage.order = "var")

PlotPFMs(PFM$everything, stage.order = "var", plot.stages = "all")

}
