% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_mstlbased.R
\name{sim_mstlbased}
\alias{sim_mstlbased}
\title{Simulate time series based on multiple seasonal decomposition}
\usage{
sim_mstlbased(y, Nsim, Combine = TRUE, M = TRUE, Future = FALSE,
  Length = NA, extralength = NA, mtd = "ets")
}
\arguments{
\item{y}{a time series or M-competition data time series (Mcomp object)}

\item{Nsim}{number of time series to simulate}

\item{Combine}{if TRUE, training and test data in the M-competition data are combined and generate a time
series corresponds to the full length of the series. Otherwise, it generate a time series
based on the training period of the series.}

\item{M}{if TRUE, y is considered to be a Mcomp data object}

\item{Future}{if future=TRUE, the simulated observations are conditional on the historical observations.
In other words, they are possible future sample paths of the time series. But if future=FALSE, the historical
data are ignored, and the simulations are possible realizations of the time series model that
are not connected to the original data.}

\item{Length}{length of the simulated time series. If future = FALSE, the Length agument should be NA.}

\item{extralength}{extra length need to be added for simulated time series}

\item{mtd}{method to use for forecasting seasonally adjusted time series}
}
\value{
A list of time series.
}
\description{
simulate multiple time series based a given series using multiple seasonal decomposition
}
\author{
Thiyanga Talagala
}
