% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutual_difference.R
\name{mutual_difference}
\alias{mutual_difference}
\title{Decomposes the difference between two M indices}
\usage{
mutual_difference(data1, data2, unit, group, weight = NULL, method = "mrc",
  se = FALSE, n_bootstrap = 50)
}
\arguments{
\item{data1}{A data frame with same structure as \code{data2}.}

\item{data2}{A data frame with same structure as \code{data1}.}

\item{unit}{A categorical variable or a vector of variables
contained in \code{data}. Defines the first dimension
over which segregation is computed.}

\item{group}{A categorical variable or a vector of variables
contained in \code{data}. Defines the second dimension
over which segregation is computed.}

\item{weight}{Numeric. Only frequency weights are allowed.
(Default \code{NULL})}

\item{method}{for now, only "mrc" (Mora and Ruiz-Castillo, 2009) is possible}

\item{se}{If \code{TRUE}, standard errors are estimated via bootstrap.
(Default \code{FALSE})}

\item{n_bootstrap}{Number of bootstrap iterations. (Default \code{50})}
}
\value{
Returns a data frame with columns \code{stat} and \code{est}. The data frame contains
  the following rows defined by \code{stat}:
  \code{M1} contains the M for \code{data1}.
  \code{M2} contains the M for \code{data2}.
  \code{diff} is the difference between \code{M2} and \code{M1}.
  \code{unit_entropy} is the difference in unit entropy.
  \code{group_marginal} is the contribution of group composition differences.
  \code{invariant} is the contribution of group composition-invariant differences.
  Note that \code{diff = unit_entropy + group_marginal + invariant}

  If \code{se} is set to \code{TRUE}, an additional column \code{se} contains
  the associated bootstrapped standard errors, and the column \code{est} contains
  bootstrapped estimates.
}
\description{
Uses the method developed by Mora and Ruiz-Castillo (2009).
}
\examples{
mutual_difference(schools00, schools05, unit="race", group="school",
    weight="n", method="mrc")
}
\references{
Ricardo Mora and Javier Ruiz-Castillo. 2009. "The Invariance Properties of the
  Mutual Information Index of Multigroup Segregation". Research on Economic Inequality 17: 33-53.
}
