% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marginalRecon.R
\name{GetMarginalAllGenes}
\alias{GetMarginalAllGenes}
\title{Get marginal reconstruction all genes}
\usage{
GetMarginalAllGenes(selac.obj, aa.optim.input = NULL,
  fasta.rows.to.keep = NULL, taxon.to.drop, partition.number = NULL)
}
\arguments{
\item{selac.obj}{An object of class SELAC.}

\item{aa.optim.input}{A list of optimal amino acids with each list element designating a character vector for each gene. The optimal amino acids be the MLE from a selac run (default) or a list of user defined optimal A.A.}

\item{fasta.rows.to.keep}{Indicates which rows to remove in the input fasta files.}

\item{taxon.to.drop}{A single taxon (defined by number in phy object) to be removed from the reconstruction.}

\item{partition.number}{If only a single gene is desired to be reconstructed, the input is the partition number in the selac object.}
}
\description{
Calculates the marginal probability of each codon at all sites across all genes
}
\details{
Provides marginal probabilities for all nodes across all genes. The function is fairly simple to use as it only requires as input the selac output object and the working directory that the original analysis took place.
}
