\name{Pval}
\alias{Pval}
\alias{dPval}
\alias{pPval}
\alias{qPval}
\alias{rPval}
\title{Functions for the distribution of p-values}
\description{The density of the \eqn{p}-value generated by a test of the hypothesis

\deqn{H_0 : Y \sim N(0, \sigma^2) \ \ vs. \ \ H_1 : Y \sim N(\theta, \eta^2)}

has the form

\deqn{f(p; \theta, \sigma, \eta) = \frac{\sigma}{2 \eta} \frac{\phi\Bigl((-\sigma \Phi^{-1}(p / 2) - \theta) / \eta\Bigr) + \phi\Bigl((\sigma \Phi^{-1}(p / 2) - \theta) / \eta\Bigr)}{\phi(\Phi^{-1}(p / 2))}}

where \eqn{\eta^2 = u^2 + \sigma^2}. We refer to Rufibach (2011) for details.
}
\usage{
dPval(p, u, theta, sigma2)
pPval(q, u, theta, sigma2)
qPval(prob, u, theta, sigma2)
rPval(n, u, theta, sigma2, seed = 1)
}
\arguments{
  \item{p, q}{Quantile.}
  \item{prob}{Probability.}
  \item{u}{Standard error of the effect size.}
  \item{theta}{Effect size.}
  \item{sigma2}{Random effect variance component.}
  \item{n}{Number of random numbers to be generated.}
  \item{seed}{Seed to set.}
}
\value{\code{dPval} gives the density, \code{pPval} gives the distribution function, \code{qPval} gives the quantile function, and \code{rPval} generates 
random deviates for the density \eqn{f(p; \theta, \sigma, \eta)}.}
\references{
Dear, K.B.G. and Begg, C.B. (1992).
An Approach for Assessing Publication Bias Prior to Performing a Meta-Analysis.
\emph{Statist. Sci.}, \bold{7(2)}, 237--245.

Rufibach, K. (2011).
Selection Models with Monotone Weight Functions in Meta-Analysis.
\emph{Biom. J.}, to appear.
}
\author{
Kaspar Rufibach (maintainer), \email{kaspar.rufibach@gmail.com}, \cr \url{http://www.kasparrufibach.ch}
}
\keyword{distribution}
\keyword{htest}
\keyword{nonparametric}

