% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/global_actions.R
\name{get_page_source}
\alias{get_page_source}
\title{Read the HTML of a session}
\usage{
get_page_source(session = NULL, ...)
}
\arguments{
\item{session}{Optionally, a \code{selenider_session} object.}

\item{...}{Passed into \code{\link[xml2:read_xml]{xml2::read_html()}}}
}
\value{
An XML document.
}
\description{
Uses \code{\link[xml2:read_xml]{xml2::read_html()}} to read the page source of the session
}
\examples{
\dontshow{if (selenider::selenider_available(online = FALSE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
html <- "
<p>Example text</p>
"

session <- minimal_selenider_session(html)

get_page_source()

\dontshow{
# Clean up all connections and invalidate default chromote object
selenider_cleanup()
}
\dontshow{\}) # examplesIf}
}
\seealso{
Other global actions: 
\code{\link{back}()},
\code{\link{current_url}()},
\code{\link{execute_js_fn}()},
\code{\link{open_url}()},
\code{\link{reload}()},
\code{\link{take_screenshot}()}
}
\concept{global actions}
