% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/semEff-fun.R
\name{print.semEff}
\alias{print.semEff}
\title{Print \code{"semEff"} Objects}
\usage{
\method{print}{semEff}(x, ...)
}
\arguments{
\item{x}{An object of class \code{"semEff"}.}

\item{...}{Further arguments passed to or from other methods. Not currently
used.}
}
\value{
A summary table for the SEM variables (data frame).
}
\description{
A \code{\link[=print]{print()}} method for an object of class \code{"semEff"}.
}
\details{
This print method returns a summary table for the SEM variables,
giving their status as exogenous or endogenous and as predictor, mediator
and/or response. It also gives the number of direct vs. indirect paths
leading to each variable, and the number of correlated errors (if
applicable).

Printing of summary tables uses a custom version of \code{print.data.frame()},
facilitating correct rendering of unicode characters by bypassing
\code{\link[=format.data.frame]{format.data.frame()}} (\href{https://stat.ethz.ch/pipermail/r-devel/2015-May/071252.html}{bug details},
workaround adapted from
\href{https://stat.ethz.ch/pipermail/r-devel/2015-May/071259.html}{here}). Row
names (numbers) are also suppressed by default.
}
