% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_cbsem.R
\name{estimate_cfa}
\alias{estimate_cfa}
\title{seminr estimate_cfa() function}
\usage{
estimate_cfa(data, measurement_model = NULL, item_associations=NULL,
             model = NULL, lavaan_model = NULL, estimator="MLR", ...)
}
\arguments{
\item{data}{A \code{dataframe} containing the indicator measurement data.

The entire CBSEM model can be specified in one of three ways:

The pair of measurement and structural models, along associated items, can optionally be specified as separate model components}

\item{measurement_model}{An optional \code{measurement_model} object representing the outer/measurement model,
as generated by \code{constructs}.
Note that only reflective constructs are supported for CBSEM models,
though a composite measurement model can be converted into a reflective one
using \code{\link{as.reflective}}.}

\item{item_associations}{An item-to-item matrix representing error
  covariances that are freed for estimation.
  This matrix is created by \code{associations()}, or defaults to NULL
  (no inter-item associations).

The combination of measurement and structural models and inter-item associations can also be specified as a single \code{specified_model} object
Note that any given model components (measurement_model, structural_model, item_associations) will override components in the fully specified model}

\item{model}{An optional \code{specified_model} object containing both the the outer/measurement and inner/structural models,
  along with any inter-item associations, as generated by \code{specify_model}.

The entire model can also be specified in Lavaan syntax (this overrides any other specifications)}

\item{lavaan_model}{Optionally, a single character string containing the relevant model specification in \code{lavaan} syntax.

Any further optional parameters to alter the estimation method:}

\item{estimator}{A character string indicating which estimation method to use
in Lavaan. It defaults to "MLR" for robust estimation.
See the Lavaan documentation for other supported estimators.}

\item{...}{Any other parameters to pass to \code{lavaan::sem} during
estimation.}
}
\description{
Estimates a Confirmatory Factor Analysis (CFA) model
}
\references{
Jöreskog, K.G. (1969) A general approach to confirmatory maximum likelihood factor analysis. Psychometrika, 34, 183-202.
}
\seealso{
\code{\link{constructs}} \code{\link{reflective}}
         \code{\link{associations}} \code{\link{item_errors}}
         \code{\link{as.reflective}}

#' @examples
mobi <- mobi

#seminr syntax for creating measurement model
mobi_mm <- constructs(
  reflective("Image",        multi_items("IMAG", 1:5)),
  reflective("Expectation",  multi_items("CUEX", 1:3)),
  reflective("Quality",      multi_items("PERQ", 1:7))
)

#seminr syntax for freeing up item-item covariances
mobi_am <- associations(
  item_errors(c("PERQ1", "PERQ2"), "CUEX3"),
  item_errors("IMAG1", "CUEX2")
)

mobi_cfa <- estimate_cfa(mobi, mobi_mm, mobi_am)
}
