% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_results.R
\name{plot_interaction}
\alias{plot_interaction}
\title{Function for plotting interaction plot for moderated PLS or CBSEM model}
\usage{
plot_interaction(moderated_model, intxn, dv, legend)
}
\arguments{
\item{moderated_model}{SEMinR model that contains an interaction.}

\item{intxn}{Name (character) of the interaction term in the structural model. Must look like a product of independent variabel and moderator (e.g., "ABC*XYZ")}

\item{dv}{Name (character) of the dependant consutruct affected by the moderator.}

\item{legend}{Location (character) of the legend on the plot; must be a combination of bottom|top and left|right (e.g., "bottomright").}
}
\description{
\code{plot_interaction} generates an interaction plot for the effect of an antecedent
  on an outcome given a mediator variable.
}
\examples{
data(mobi)

# seminr syntax for creating measurement model
mobi_mm <- constructs(
composite("Image",        multi_items("IMAG", 1:5)),
composite("Expectation",  multi_items("CUEX", 1:3)),
composite("Value",        multi_items("PERV", 1:2)),
composite("Satisfaction", multi_items("CUSA", 1:3)),
interaction_term(iv = "Image", moderator = c("Expectation"), method = orthogonal))

# Structural model
#  note: interactions should be the names of its main constructs joined by a '*' in between.
mobi_sm <- relationships(
  paths(to = "Satisfaction",
        from = c("Image", "Expectation", "Value",
                 "Image*Expectation")))

# Load data, assemble model, and estimate
mobi_pls <- estimate_pls(data = mobi,
                         measurement_model = mobi_mm,
                         structural_model = mobi_sm)

plot_interaction(mobi_pls, "Image*Expectation", "Satisfaction", "bottomright")

}
