% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_sobol.R
\name{plot_scatter}
\alias{plot_scatter}
\title{Scatterplots of the model output against the model inputs}
\usage{
plot_scatter(x, Y, n, params)
}
\arguments{
\item{x}{A data table, data frame or matrix with the
model inputs.}

\item{Y}{Numeric vector with the model output.}

\item{n}{Integer, sample size of the Sobol' matrix.}

\item{params}{Vector with the name of the model inputs.}
}
\value{
A ggplot object.
}
\description{
Scatterplots of the model output against the model inputs
}
\examples{
# Define settings:
n <- 100; k <- 8; R <- 10
# Design the sample matrix:
A <- sobol_matrices(n = n, k = k, second = TRUE, third = TRUE)
# Compute the model output:
Y <- sobol_Fun(A)
# Plot scatterplots:
plot_scatter(x = A, Y = Y, n = n, params = colnames(data.frame(A)))
}
