% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sentomeasures.R
\name{sento_measures}
\alias{sento_measures}
\title{One-way road towards a sentomeasures object}
\usage{
sento_measures(sentocorpus, lexicons, ctr)
}
\arguments{
\item{sentocorpus}{a \code{sentocorpus} object created with \code{\link{sento_corpus}}.}

\item{lexicons}{output from a \code{\link{setup_lexicons}} call.}

\item{ctr}{output from a \code{\link{ctr_agg}} call.}
}
\value{
A \code{sentomeasures} object, which is a \code{list} containing:
\item{measures}{a \code{data.table} with a \code{"date"} column and all textual sentiment measures as remaining columns.}
\item{features}{a \code{character} vector of the different features.}
\item{lexicons}{a \code{character} vector of the different lexicons used.}
\item{time}{a \code{character} vector of the different time weighting schemes used.}
\item{by}{a single \code{character} vector specifying the time interval of aggregation used.}
\item{stats}{a \code{data.frame} with a series of elementary statistics (mean, standard deviation, maximum, minimum, and
average correlation with all other measures) for each individual sentiment measure.}
\item{sentiment}{the sentiment scores \code{data.table} with \code{"date"} and lexicon--feature sentiment scores columns.
If \code{ctr$do.ignoreZeros = TRUE}, all zeros are replaces by \code{NA}.}
\item{howWithin}{a single \code{character} vector to remind how sentiment within documents was aggregated.}
\item{howDocs}{a single \code{character} vector to remind how sentiment across documents was aggregated.}
\item{fill}{a single \code{character} vector that specifies if and how missing dates have been added before
aggregation across time was carried out.}
\item{do.ignoreZeros}{a single \code{character} vector to remind if documents with zero sentiment have been ignored in the
within-document aggregation.}
\item{attribWeights}{a \code{list} of document and time weights used in the \code{\link{retrieve_attributions}} function.
Serves further no direct purpose.}
}
\description{
Wrapper function which assembles calls to \code{\link{compute_sentiment}} and \code{\link{perform_agg}}, and
includes the input \code{sentocorpus} and computed sentiment scores in its output. Serves as the most direct way towards a
panel of textual sentiment measures as a \code{sentomeasures} object.
}
\examples{
data("usnews")
data("lexicons")
data("valence")

# construct a sentomeasures object to start with
corpus <- sento_corpus(corpusdf = usnews)
corpusSample <- quanteda::corpus_sample(corpus, size = 750)
l <- setup_lexicons(lexicons[c("LM_eng", "HENRY_eng")], valence[["valence_eng"]])
ctr <- ctr_agg(howWithin = "tf-idf",
               howDocs = "proportional",
               howTime = c("equal_weight", "linear", "almon"),
               by = "month",
               lag = 3,
               ordersAlm = 1:3,
               do.inverseAlm = TRUE,
               do.normalizeAlm = TRUE)
sentomeasures <- sento_measures(corpusSample, l, ctr)
summary(sentomeasures)

}
\seealso{
\code{\link{compute_sentiment}}, \code{\link{perform_agg}}
}
\author{
Samuel Borms, Keven Bluteau
}
