% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Prepare.R
\name{SeqPrep}
\alias{SeqPrep}
\title{preparations}
\usage{
SeqPrep(GenoM = NULL, LifeHistData = NULL, nAgeClasses = 1,
  MaxSibIter = 5, Err = 1e-04, MaxMismatch = 3, Tfilter = -2,
  Tassign = 0.5, MaxSibshipSize = 100, DummyPrefix = c("F", "M"),
  Complexity = "full", UseAge = "yes", FindMaybeRel = TRUE,
  CalcLLR = TRUE)
}
\arguments{
\item{GenoM}{matrix with genotype data, size nInd x nSnp}

\item{LifeHistData}{Dataframe with 3 columns:
\itemize{
\item{ID: }{max. 30 characters long,}
\item{Sex: }{1 = females, 2 = males, other numbers = unkown,}
\item{Birth Year: }{(or hatching year) Zero and negative numbers are
  interpreted as missing values.}}}

\item{nAgeClasses}{Number of age classes (= no. rows in AgePriors)}

\item{MaxSibIter}{Maximum number of iterations of sibship clustering
(up to 42).}

\item{Err}{Estimated genotyping error rate.}

\item{MaxMismatch}{Maximum number of loci at which candidate parent and
offspring are allowed to be opposite homozygotes, or be excluded.}

\item{Tfilter}{Threshold log-likelihood ratio between a proposed
relationship versus unrelated, to select candidate relatives. Typically a
negative value, related to the fact that unconditional likelihoods are
calculated during the filtering steps. More negative values may decrease
non-assignment, but will increase computational time.}

\item{Tassign}{Minimum log-likelihood ratio required for acceptance of
proposed relationship, relative to next most likely relationship. Higher
values result in more conservative assignments.}

\item{MaxSibshipSize}{Maximum number of offspring for a single individual
(a generous safety margin is advised).}

\item{DummyPrefix}{character vector of length 2 with prefixes for dummy
dams (mothers) and sires (fathers); maximum 20 characters each.}

\item{Complexity}{Either "full" (default), "simp" (no explicit consideration
of inbred relationships), "mono" (monogamous breeding system), or "herm"
(hermaphrodites)}

\item{FindMaybeRel}{Identify pairs of non-assigned likely relatives after
pedigree reconstruction. Can be time-consuming in large datasets.}

\item{CalcLLR}{Calculate log-likelihood ratios for all assignments. Can be
time-consuming in large datasets.}
}
\value{
A 1-row dataframe with parameter values
}
\description{
Check parameter values and save as named vector.
}
\details{
Please do not increasing the number of SNPs or individuals beyond
 the numbers present in the datasets, as this may cause R to crash.
}
\keyword{internal}
