% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/listPorts.R
\name{listPorts}
\alias{listPorts}
\title{Lists the serial interfaces.}
\usage{
listPorts()
}
\value{
A character vector with the list of comports is returned.
}
\description{
This function lists all installed serial interfaces in a computer.
Thereby Windows, Linux and MacOs behave different. Please ensure
that you have the appropriate permissions to do a search in the registry or
in the corresponding linux folders.
}
\section{Windows}{


In a Windows environment, this function tries to read out the registry keys
located in:

\code{"HKEY_LOCAL_MACHINE\\HARDWARE\\DEVICEMAP\\SERIALCOMM"}

This should be consistent with all installed hardware ports plus all virtual
ports.
}

\section{Linux and MacOS}{


Here the situation is different, compared to Windows. All possible serial 
devices are located in \code{"/dev/tty[...]"} as a file connection. Still, all
virtual and closed dev's can be found here. This is confusing, because one will 
find more devices in this folder than physically (virtual) present.
In addition to that, Ubuntu linux systems do list the plug and play devices 
of interest in "\code{/sys/devices/pnp0/...}" again. That is the reason why, 
the function returns a subset of \code{"/dev/tty[...]"}, which is also present in the 
\code{"../pnp0/.."} folder.

On MacOs the installed interfaces are marked by "\code{tty.<name>}", with a unique 
name after the dot, which makes it easier to search for installed devices.

Subsequently, the user must know which interface is present and which isn't. AND the user
must have at least reading permissions in the corresponding folders. So in the end,
this function is a best guess of what is installed.
}

