% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/serial.R
\name{read.serialConnection}
\alias{read.serialConnection}
\title{Reads from the serial interface.}
\usage{
read.serialConnection(con,n = 0)
}
\arguments{
\item{con}{serial connection}

\item{n}{number of bytes to read. Only in binary mode. 
\code{n=0} (default) reads the whole buffer at once.}
}
\value{
In normal mode the result is a string. In binary mode raw values will 
be returned
}
\description{
This function reads from the serial interface as long as the buffer is not
empty. The read takes place per line in normal operation mode. Here end-of-line
characters (\\n;\\r) are clipped according to the settings (\code{translation}).
}
\details{
In binary (hex-) mode the read takes place per byte. The result is a raw 
vector of hexadecimal numbers. To get numeric values \code{as.numeric} 
function must be invoked.
Mind: Values form 0x01 -- 0x31 might be displayed as escaped characters like
 "\\001" if they are interpreted as string.
If the end-of-file character specified by \code{eof} is received the reading 
stops. A \code{close(con)} -- \code{open(con)} sequence must be invoked to 
reopen the connection.
If \code{n>0} <n> bytes will be read. In case of less than \code{n} bytes 
available the function returns the buffer without waiting for all \code{n} 
characters.
}
\examples{
 # See the top package documentation
}
\seealso{
\code{\link{serial}}
}
