% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.seroincidence.by.R
\name{print.seroincidence.by}
\alias{print.seroincidence.by}
\title{Print Method for \code{seroincidence.by} Object}
\usage{
\method{print}{seroincidence.by}(x, ...)
}
\arguments{
\item{x}{A list containing output of function \code{\link[=est.incidence.by]{est.incidence.by()}}.}

\item{...}{Additional arguments affecting the summary produced.}
}
\value{
A \code{list} containing the output of the function \code{est.incidence.by()}.
}
\description{
Custom \code{\link[=print]{print()}} function to show output of the seroincidence calculator \code{\link[=est.incidence.by]{est.incidence.by()}}.
}
\examples{

\donttest{

library(tidyverse)

xs_data <- load_pop_data("https://osf.io/download//n6cp3/") \%>\%
  clean_pop_data()

curve <- load_curve_params("https://osf.io/download/rtw5k/") \%>\%
  filter(antigen_iso \%in\% c("HlyE_IgA", "HlyE_IgG")) \%>\%
  slice(1:100, .by = antigen_iso) # Reduce dataset for the purposes of this example

noise <- load_noise_params("https://osf.io/download//hqy4v/")


est2 <- est.incidence.by(
  strata = c("catchment"),
  pop_data = xs_data \%>\% filter(Country == "Pakistan"),
  curve_params = curve,
  noise_params = noise \%>\% filter(Country == "Pakistan"),
  antigen_isos = c("HlyE_IgG", "HlyE_IgA"),
  #num_cores = 8 # Allow for parallel processing to decrease run time
)

print(est2)
}

}
