% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{vzv_be_1999_2000}
\alias{vzv_be_1999_2000}
\title{VZV serological data from Belgium (Flanders) from 1999-2000 (aggregated)}
\format{
A data frame with 3 variables:
\describe{
 \item{age}{Age group}
 \item{pos}{Number of seropositive individuals}
 \item{tot}{Total number of individuals surveyed}
}
}
\source{
Thiry, N., Beutels, P., Shkedy, Z. et al. The seroepidemiology
of primary varicella-zoster virus infection in Flanders (Belgium).
Eur J Pediatr 161, 588-593 (2002).
\doi{doi:10.1007/s00431-002-1053-2}
}
\usage{
vzv_be_1999_2000
}
\description{
Age-specific seroprevalence of VZV antibodies, assessed in Flanders (Belgium)
between October 1999 and April 2000. This population was stratified by age
in order to obtain approximately 100 observations per age group.
}
\examples{
# Reproduce Fig 4.7 (left panel), p.71
age <- vzv_be_1999_2000$age
pos <- vzv_be_1999_2000$pos
tot <- vzv_be_1999_2000$tot
plot(age, pos / tot,
  cex = 0.036 * tot, pch = 19, xlab = "age", ylab = "seroprevalence",
  xlim = c(0, 45), ylim = c(0, 1)
)

}
\keyword{datasets}
