% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_functions.R
\name{sst_lists_to_df}
\alias{sst_lists_to_df}
\title{Convert list of lists to data.frame}
\usage{
sst_lists_to_df(lists, fill = NA)
}
\arguments{
\item{lists}{- a list of nested lists with different number of elements}

\item{fill}{- a value to fill missing values in lists}
}
\value{
A data.frame with all missing values filed with specified value.
}
\description{
API response might contain nested lists with different number of elements.
This function fills missing elements and combine lists to a
data.frame.
}
\examples{
sst_lists_to_df(
  lists = list(
    first_list  = list(a = 1, b = 2),
    second_list = list(a = 2, c = 3)
  ),
  fill  = 'empty'
)
}
