% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{computeLogLikelihood}
\alias{computeLogLikelihood}
\title{Compute the log-likelihood.}
\usage{
computeLogLikelihood(obsi, lambda, prErrNu, prErrSS, basisMx, eigVal,
  precMx, xTx, aMx, ruMx)
}
\arguments{
\item{obsi}{Vector of residuals after the spectral signature has been subtracted.}

\item{lambda}{smoothing parameter of the penalised B-spline.}

\item{prErrNu}{hyperparameter of the additive noise}

\item{prErrSS}{hyperparameter of the additive noise}

\item{basisMx}{Matrix of B-spline basis functions}

\item{eigVal}{eigenvalues of the Demmler-Reinsch factorisation}

\item{precMx}{precision matrix for the spline}

\item{xTx}{sparse matrix cross-product}

\item{aMx}{orthoganal matrix A from the Demmler-Reinsch factorisation}

\item{ruMx}{product of Ru from the Demmler-Reinsch factorisation}
}
\value{
The logarithm of the likelihood.
}
\description{
This is an internal function that is only exposed on the public API for unit testing purposes.
It computes the log-likelihood of the spline and the noise, once the spectral signature has
been subtracted from the observed data. Thus, it can be used with either Lorentzian, Gaussian,
or pseudo-Voigt broadening functions.
}
