% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertions.R
\name{testSubset}
\alias{testSubset}
\alias{checkSubset}
\alias{assertSubset}
\title{assert/check/test/Subset}
\usage{
testSubset(
  object,
  sets,
  proper = FALSE,
  errormsg = "sets are not subsets of the object"
)

checkSubset(
  object,
  sets,
  proper = FALSE,
  errormsg = "sets are not subsets of the object"
)

assertSubset(
  object,
  sets,
  proper = FALSE,
  errormsg = "sets are not subsets of the object"
)
}
\arguments{
\item{object}{object to test}

\item{sets}{sets to check}

\item{proper}{logical. If TRUE tests for proper subsets.}

\item{errormsg}{error message to overwrite default if check fails}
}
\value{
If check passes then \code{assert} returns \code{object} invisibly and \code{test}/\code{check}
return \code{TRUE}. If check fails, \code{assert} stops code with error, \code{check} returns
an error message as string, and \code{test} returns \code{FALSE}.
}
\description{
Validation checks to test if given sets are subsets of a set.
}
\examples{
testSubset(Set$new(1,2,3), Set$new(1,2))
testSubset(Set$new(1,2,3), Set$new(3,4))
}
