% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-permission.R
\name{Permission}
\alias{Permission}
\title{R6 Class representing member's permissions}
\description{
R6 Class representing member's permissions.
}
\examples{

## ------------------------------------------------
## Method `Permission$print`
## ------------------------------------------------

\dontrun{
 # x is API response when permission is requested
 permission_object <- Permission$new(
                    write = x$write,
                    read = x$read,
                    copy = x$copy,
                    execute = x$execute,
                    admin = x$admin,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )
 # Print permission object
 permission_object$print()
}


## ------------------------------------------------
## Method `Permission$reload`
## ------------------------------------------------

\dontrun{
 # x is API response when permission is requested
 permission_object <- Permission$new(
                    write = x$write,
                    read = x$read,
                    copy = x$copy,
                    execute = x$execute,
                    admin = x$admin,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Reload permission object
 permission_object$reload()
}

}
\section{Super class}{
\code{\link[sevenbridges2:Item]{sevenbridges2::Item}} -> \code{Permission}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{write}}{Write permission.}

\item{\code{read}}{Read permission.}

\item{\code{copy}}{Copy permission.}

\item{\code{execute}}{Execute permission.}

\item{\code{admin}}{Admin permission.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Permission-new}{\code{Permission$new()}}
\item \href{#method-Permission-print}{\code{Permission$print()}}
\item \href{#method-Permission-reload}{\code{Permission$reload()}}
\item \href{#method-Permission-clone}{\code{Permission$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Permission-new"></a>}}
\if{latex}{\out{\hypertarget{method-Permission-new}{}}}
\subsection{Method \code{new()}}{
Create a new Permission object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Permission$new(
  read = TRUE,
  copy = FALSE,
  write = FALSE,
  execute = FALSE,
  admin = FALSE,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{read}}{User can view file names, metadata, and workflows.
They cannot view file contents. All members of a project have read
permissions by default. Even if you try setting read permissions to
\code{FALSE}, they will still default to \code{TRUE}}

\item{\code{copy}}{User can view file content, copy, and download files from a
project. Set value to \code{TRUE} to assign the user copy permission.
Set to \code{FALSE} to remove copy permission.}

\item{\code{write}}{User can add, modify, and remove files and workflows in a
project. Set value to \code{TRUE} to assign the user write permission.
Set to \code{FALSE} to remove write permission.}

\item{\code{execute}}{User can execute workflows and abort tasks in a project.
Set value to \code{TRUE} to assign the user execute permission.
Set to \code{FALSE} to remove execute permission.}

\item{\code{admin}}{User can modify another user's permissions on a project,
add or remove people from the project and manage funding sources.
They also have all of the above permissions. Set value to \code{TRUE} to
assign the user admin permission. Set to \code{FALSE} to remove admin
permission.}

\item{\code{...}}{Other response arguments.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Permission-print"></a>}}
\if{latex}{\out{\hypertarget{method-Permission-print}{}}}
\subsection{Method \code{print()}}{
Print method for Permission class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Permission$print()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 # x is API response when permission is requested
 permission_object <- Permission$new(
                    write = x$write,
                    read = x$read,
                    copy = x$copy,
                    execute = x$execute,
                    admin = x$admin,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )
 # Print permission object
 permission_object$print()
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Permission-reload"></a>}}
\if{latex}{\out{\hypertarget{method-Permission-reload}{}}}
\subsection{Method \code{reload()}}{
Reload Permission object information.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Permission$reload()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 # x is API response when permission is requested
 permission_object <- Permission$new(
                    write = x$write,
                    read = x$read,
                    copy = x$copy,
                    execute = x$execute,
                    admin = x$admin,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Reload permission object
 permission_object$reload()
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Permission-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Permission-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Permission$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
