% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R, R/db.R
\name{st_write}
\alias{st_write}
\alias{st_write_db}
\title{Write simple features object to file or database}
\usage{
st_write(obj, dsn, layer = basename(dsn),
  driver = guess_driver_can_write(dsn), ..., dataset_options = NULL,
  layer_options = NULL, quiet = FALSE, factorsAsCharacter = TRUE)

st_write_db(conn = NULL, obj, table = substitute(obj),
  geom_name = "wkb_geometry", ..., overwrite = FALSE, append = FALSE,
  binary = TRUE, debug = FALSE)
}
\arguments{
\item{obj}{object of class \code{sf} or \code{sfc}}

\item{dsn}{data source name (interpretation varies by driver - for some drivers, dsn is a file name, but may also be a folder or contain a database name)}

\item{layer}{layer name (varies by driver, may be a file name without extension); if layer is missing, the \link{basename} of \code{dsn} is taken.}

\item{driver}{character; driver name to be used, if missing, a driver name is guessed from \code{dsn}; \code{st_drivers()} returns the drivers that are available with their properties; links to full driver documentation are found at \url{http://www.gdal.org/ogr_formats.html}.}

\item{...}{arguments passed on to \code{dbWriteTable}}

\item{dataset_options}{character; driver dependent dataset creation options; multiple options supported.}

\item{layer_options}{character; driver dependent layer creation options; multiple options supported.}

\item{quiet}{logical; suppress info on name, driver, size and spatial reference}

\item{factorsAsCharacter}{logical; convert \code{factor} objects into character strings (default), else into numbers by \code{as.numeric}.}

\item{conn}{open database connection}

\item{table}{name for the table in the database}

\item{geom_name}{name of the geometry column in the database}

\item{overwrite}{logical; should \code{table} be dropped first?}

\item{append}{logical; append to table? (NOTE: experimental, might not work)}

\item{binary}{logical; use well-known-binary for transfer?}

\item{debug}{logical; print SQL statements to screen before executing them.}
}
\description{
Write simple features object to file or database

Write simple feature table to a spatial database
}
\details{
columns (variables) of a class not supported are dropped with a warning.
}
\examples{
nc = st_read(system.file("shape/nc.shp", package="sf"))
st_write(nc, "nc.shp")

\dontrun{
library(sp)
example(meuse, ask = FALSE, echo = FALSE)
st_write(st_as_sf(meuse), "PG:dbname=postgis", "meuse_sf",
    layer_options = c("OVERWRITE=yes", "LAUNDER=true"))
demo(nc, ask = FALSE)
st_write(nc, "PG:dbname=postgis", "sids", layer_options = "OVERWRITE=true")}
\dontrun{
library(sp)
data(meuse)
sf = st_as_sf(meuse, coords = c("x", "y"), crs = 28992)
library(RPostgreSQL)
conn = dbConnect(PostgreSQL(), dbname = "postgis")
st_write_db(conn, sf, "meuse_tbl", drop_table = FALSE)}
  
}
\seealso{
\link{st_drivers}
}

