% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arith.R
\name{ops}
\alias{ops}
\alias{Ops.sfg}
\alias{ops}
\alias{Ops.sfc}
\title{S3 Ops Group Generic Functions (multiply and add/subtract) for affine transformation}
\usage{
\method{Ops}{sfg}(e1, e2)

\method{Ops}{sfc}(e1, e2)
}
\arguments{
\item{e1}{object of class \code{sfg}}

\item{e2}{numeric of object of class \code{sfg}; in case of multiplication an n x n matrix, in case of addition or subtraction a vector of length n, with n the number of dimensions of the geometry; if \code{e2} is an \code{sfg} object, \code{+}, \code{-}, \code{*} and \code{/} will result in the geometric union, difference, intersection and symmetric difference respectively; for other operators will lead to \code{e2} being converted to a numeric.}
}
\value{
object of class \code{sfg}
}
\description{
Ops functions for simple feature geometry objects (constrained to multiplication and addition)
}
\examples{
st_point(c(1,2,3)) + 4
st_point(c(1,2,3)) * 3 + 4
m = matrix(0, 2, 2)
diag(m) = c(1, 3)
# affine:
st_point(c(1,2)) * m + c(2,5)
# world in 0-360 range:
library(maps)
w = st_as_sf(map('world', plot = FALSE, fill = TRUE))
w2 = (st_geometry(w) + c(360,90)) \%\% c(360) - c(0,90)
w3 = st_wrap_dateline(st_set_crs(w2 - c(180,0), 4326)) + c(180,0)
plot(st_set_crs(w3, 4326), axes = TRUE)
(mp <- st_point(c(1,2)) + st_point(c(3,4))) # MULTIPOINT (1 2, 3 4)
mp - st_point(c(3,4)) # POINT (1 2)
opar = par(mfrow = c(2,2), mar = c(0, 0, 1, 0))
a = st_buffer(st_point(c(0,0)), 2)
b = a + c(2, 0) 
p = function(m) { plot(c(a,b)); plot(eval(parse(text=m)), col=grey(.9), add = TRUE); title(m) }
lapply(c('a + b', 'a - b', 'a * b', 'a / b'), p)
par(opar)
nc = st_transform(st_read(system.file("gpkg/nc.gpkg", package="sf")), 32119) # nc state plane, m
b = st_buffer(st_centroid(st_union(nc)), units::set_units(50, km)) # shoot a hole in nc:
plot(st_geometry(nc) - b, col = grey(.9))
}
