% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_table.R
\name{get_table}
\alias{get_table}
\title{Get 'nomis' Table}
\usage{
get_table(id, options, selection = NULL, uid = NULL)
}
\arguments{
\item{id}{a table ID recognised by 'nomis' (e.g. "NM_1_1")}

\item{options}{a list of paramaters to pass to the API query.}

\item{selection}{a vector of column names to return. NULL returns all. Defaults to NULL.}

\item{uid}{Unique 'nomis' identifier to enable larger 'nomis' queries - https://www.nomisweb.co.uk/. Defaults to NULL.}
}
\value{
A tidy dataframe of selected 'nomis' table with the selected parameters and user filters applied.
}
\description{
Retrieve a 'nomis' table, containing the columns of interest, using a given table ID.
Option to apply filters to the query, and to circumnavigate the limit on number of rows returned using your 'nomis' uid.
}
\examples{
get_table(id="NM_1_1", options = list("geography" = "TYPE480", "time" = "latest"))
get_table(id="NM_1002_1", options = list("geography" = "TYPE265", "time" = "latest"),
selection = "GEOGRAPHY_NAME,C_AGE_NAME,OBS_VALUE",uid=NULL)

}
