% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sgdGMF-class.R
\name{residuals.sgdgmf}
\alias{residuals.sgdgmf}
\alias{resid.sgdgmf}
\title{Extract the residuals of a GMF model}
\usage{
\method{residuals}{sgdgmf}(
  object,
  ...,
  type = c("deviance", "pearson", "working", "response", "link"),
  partial = FALSE,
  normalize = FALSE,
  fillna = FALSE,
  spectrum = FALSE,
  ncomp = 50
)

\method{resid}{sgdgmf}(
  object,
  ...,
  type = c("deviance", "pearson", "working", "response", "link"),
  partial = FALSE,
  normalize = FALSE,
  fillna = FALSE,
  spectrum = FALSE,
  ncomp = 50
)
}
\arguments{
\item{object}{an object of class \code{sgdgmf}}

\item{...}{further arguments passed to or from other methods}

\item{type}{the type of residuals which should be returned}

\item{partial}{if \code{TRUE}, computes the residuals excluding the matrix factorization from the linear predictor}

\item{normalize}{if \code{TRUE}, standardize the residuals column-by-column}

\item{fillna}{if \code{TRUE}, fills \code{NA} values column-by-column}

\item{spectrum}{if \code{TRUE}, returns the eigenvalues of the residual covariance matrix}

\item{ncomp}{number of eigenvalues to be calculated (only if \code{spectrum=TRUE})}
}
\value{
If \code{spectrum=FALSE}, a matrix containing the selected residuals.
If \code{spectrum=TRUE}, a list containing the residuals (\code{res}), the first \code{ncomp}
eigenvalues of the residual covariance matrix, say (\code{lambdas}), the variance explained by the first
\code{ncomp} principal component of the residuals (\code{explained.var}), the variance not
explained by the first \code{ncomp} principal component of the residuals (\code{residual.var}),
the total variance of the residuals (\code{total.var}).
}
\description{
Extract the residuals of a GMF model and, if required, compute the eigenvalues
of the residuals covariance/correlation matrix.
Moreover, if required, return the partial residual of the model obtained by
excluding the matrix decomposition from the linear predictor.
}
\details{
Let \eqn{g(\mu) = \eta = X B^\top + \Gamma Z^\top + U V^\top} be the linear predictor of a
GMF model. Let \eqn{R = (r_{ij})} be the correspondent residual matrix.
The following residuals can be considered:
\itemize{
\item deviance: \eqn{r_{ij}^{_D} = \textrm{sign}(y_{ij} - \mu_{ij}) \sqrt{D(y_{ij}, \mu_{ij})}};
\item Pearson: \eqn{r_{ij}^{_P} = (y_{ij} - \mu_{ij}) / \sqrt{\nu(\mu_{ij})}};
\item working: \eqn{r_{ij}^{_W} = (y_{ij} - \mu_{ij}) / \{g'(\mu_{ij}) \,\nu(\mu_{ij})\}};
\item response: \eqn{r_{ij}^{_R} = y_{ij} - \mu_{ij}};
\item link: \eqn{r_{ij}^{_G} = g(y_{ij}) - \eta_{ij}}.
}
If \code{partial=TRUE}, \eqn{mu} is computed excluding the latent matrix decomposition
from the linear predictor, so as to obtain the partial residuals.

Let \eqn{\Sigma} be the empirical variance-covariance matrix of \eqn{R}, being
\eqn{\sigma_{ij} = \textrm{Cov}(r_{:i}, r_{:j})}. Then, the latent spectrum of
the model is the collection of eigenvalues of \eqn{\Sigma}.

Notice that, in case of Gaussian data, the latent spectrum corresponds to the principal
component analysis on the regression residuals, whose eigenvalues can be used to
infer the amount of variance explained by each principal component. Similarly,
we can use the (partial) latent spectrum in non-Gaussian data settings to infer
the correct number of principal components to include into the GMF model or to
detect some residual dependence structures not already explained by the model.
}
\examples{
# Load the sgdGMF package
library(sgdGMF)

# Generate data from a Poisson model
data = sim.gmf.data(n = 100, m = 20, ncomp = 5, family = poisson())

# Fit a GMF model with 3 latent factors
gmf = sgdgmf.fit(data$Y, ncomp = 3, family = poisson())

# Get the deviance residuals of a GMF model
str(residuals(gmf)) # returns the overall deviance residuals
str(residuals(gmf, partial = TRUE)) # returns the partial residuals
str(residuals(gmf, spectrum = TRUE)) # returns the eigenvalues of the residual var-cov matrix

}
