% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sgee.control.R
\name{sgee.control}
\alias{sgee.control}
\title{Auxiliary for Controlling SGEE fitting}
\usage{
sgee.control(maxIt = 200, epsilon = 0.05, stoppingThreshold = NULL,
  undoThreshold = 0.005, interceptLimit = NULL)
}
\arguments{
\item{maxIt}{Maximum number of iterations of the stagewise algorithm to be
executed. Default is 200.}

\item{epsilon}{Step size to be used when incrementing coefficient value(s)
in each iteration. Default is 0.05.}

\item{stoppingThreshold}{An integer value that indicates the maximum number
of allowed covariates in the model. Once the algorithm has reached the value
of \code{stoppingThreshold}, the algorithm will stop without completing any
remaining iterations. The number of covariates to be included cannot exceed
the number of observations. The default value is typically
the minimum of the number
of covariates and the number of observations, minus 1 if an intercept is
included.}

\item{undoThreshold}{A small value used to determine if consecutive
steps are sufficiently different. If consecutive steps effectively undo each
other (as indicated by having a sum with an absolute value less than
\code{undoThreshold}), then the steps are repeated and the stepsize is
reduced. A negative value for \code{undoThreshold} effectively prevents
this step. \code{undoThreshold} should only be big enough to allow for
some rounding error in steps and should be much smaller than the step size.
Default value is 0.005.}

\item{interceptLimit}{sgee functions make use of the extendInt parameter
of uniroot to estimate the intercept in each iteration. This parameter
was recently implemented and thus may cause issues with older versions of R.
If a value is given for \code{interceptLimit}, then this extendInt parameter
is bypassed and a solution for the intercept estimating equation is sought
out between negative \code{interceptLimit} and positive
\code{interceptLimit}. The default value of \code{NULL} uses the
extendInt functionality.}
}
\value{
A list containing all of the parameter values.
}
\description{
Auxiliary function for \code{sgee} fitting functions. Specifies
parameters used by all \code{sgee} fitting functions in terms
of the path generation; i.e. step size \code{epsilon}, maximum number of
iterations \code{maxIt}, and the threshold for premature stopping
\code{stoppingthreshold}.
}
\author{
Gregory Vaughan
}
