% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/translate_raster.R
\name{translate_raster}
\alias{translate_raster}
\title{translate_raster}
\usage{
translate_raster(raster, steps_x = NULL, steps_y = NULL,
  return_input = TRUE, simplify = FALSE, verbose = TRUE)
}
\arguments{
\item{raster}{RasterLayer.}

\item{steps_x, steps_y}{Number of steps (cells) the raster is translated into
the corresponding direction. If both are null, all possible combinations are used.}

\item{return_input}{The original input data is returned as last list entry.}

\item{simplify}{If n_random = 1 and return_input = FALSE only raster will be returned.}

\item{verbose}{Print progress report.}
}
\value{
list
}
\description{
Torus translation
}
\details{
Torus translation test as described in Harms et al. (20001). The raster is shifted
in all four cardinal directions by steps equal to the raste resolution. If a cell
exits the extent on one side, it enters the extent on the opposite side.
}
\examples{
\dontrun{
landscape_classified <- classify_habitats(landscape, classes = 5)

landscape_random <- translate_raster(landscape_classified)
landscape_random_sub <- translate_raster(landscape_classified, steps_x = 1:10, steps_y = 1:5)
}

}
\references{
Harms, K. E., Condit, R., Hubbell, S. P., & Foster, R. B. (2001). Habitat associations
of trees and shrubs in a 50-ha neotropical forest plot. Journal of Ecology, 89(6), 947-959.
}
\seealso{
\code{\link{randomize_raster}}
}
