% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explanatory_performance.R
\name{ROC}
\alias{ROC}
\title{Receiver Operating Characteristic (ROC)}
\usage{
ROC(predicted, observed, n_thr = NULL)
}
\arguments{
\item{predicted}{numeric predicted scores.}

\item{observed}{factor encoding the observed binary status.}

\item{n_thr}{number of thresholds to use to construct the ROC curve. For
faster computations on large data, values below \code{length(x)-1} can be
used.}
}
\value{
A list with: \item{TPR}{True Positive Rate.} \item{FPR}{False
  Positive Rate.} \item{AUC}{Area Under the Curve.}
}
\description{
Computes the True and False Positive Rates (TPR and FPR, respectively) and
Area Under the Curve (AUC) by comparing the true (observed) and predicted
status using a range of thresholds on the predicted score.
}
\examples{
# Data simulation
set.seed(1)
simul <- SimulateRegression(n = 500, pk = 20, family = "binomial")

# Balanced training/test split
ids_train <- Resample(
  data = simul$ydata,
  tau = 0.5, family = "binomial"
)
xtrain <- simul$xdata[ids_train, , drop = FALSE]
ytrain <- simul$ydata[ids_train, , drop = FALSE]
x2 <- simul$xdata[-ids_train, , drop = FALSE]
y2 <- simul$ydata[-ids_train, , drop = FALSE]
ids_recalib <- Resample(
  data = y2,
  tau = 0.5, family = "binomial"
)
xrecalib <- x2[ids_recalib, , drop = FALSE]
yrecalib <- y2[ids_recalib, , drop = FALSE]
xtest <- x2[-ids_recalib, ]
ytest <- y2[-ids_recalib, ]

# Stability selection and recalibration
stab <- VariableSelection(xdata = xtrain, ydata = ytrain, family = "binomial")
recalibrated <- Recalibrate(xdata = xrecalib, ydata = yrecalib, stability = stab)

# ROC analysis
predicted <- predict(recalibrated, newdata = as.data.frame(xtest))
roc <- ROC(predicted = predicted, observed = ytest)
PlotROC(roc)
plot(roc) # alternative formulation
}
\seealso{
Other prediction performance functions: 
\code{\link{ExplanatoryPerformance}()},
\code{\link{Incremental}()},
\code{\link{PlotIncremental}()},
\code{\link{PlotROC}()}
}
\concept{prediction performance functions}
