% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_classifier.R
\name{build_classifier}
\alias{build_classifier}
\title{Produce a set of SVM classifiers}
\usage{
build_classifier(
  X,
  Y,
  train.size = 0.7,
  quantile.percentage = 1,
  min.points = 3,
  gamma.length = 50,
  cost = 10000,
  weights = c(0.25, 0.75),
  best.stdev.purity = 0
)
}
\arguments{
\item{X}{matrix defining the input space of your dataset}

\item{Y}{numerical vector defining the output space (labels/classes) of your dataset}

\item{train.size}{fraction of examples used for training}

\item{quantile.percentage}{real number to define the quantile of distances to be considered (e.g. 0.1 means 10\%)}

\item{min.points}{minimal number of examples per classification region of the input space}

\item{gamma.length}{number of possible gamma parameters to test the radial kernel for SVM}

\item{cost}{the cost for the SVM optimization}

\item{weights}{weights to be used in our SVM optimization}

\item{best.stdev.purity}{the stdev to compute data purity}
}
\value{
A list of classifiers composing the final classification model
}
\description{
This function outputs a set of SVM classifiers to perform the supervised learning task
based on the topological data analysis
}
\section{References}{
 de Mello, R.F. (2019) "On the Shattering Coefficient of Supervised Learning Algorithms" arXiv:\url{https://arxiv.org/abs/1911.05461}

 de Mello, R.F., Ponti, M.A. (2018, ISBN: 978-3319949888) "Machine Learning: A Practical Approach on the Statistical Learning Theory"
}

\examples{

# require(NMF)
# 
# X = cbind(rnorm(mean=-1, sd=1, n=200), rnorm(mean=-1, sd=1, n=200))
# X = rbind(X, cbind(rnorm(mean=1, sd=1, n=200), rnorm(mean=1, sd=1, n=200)))
# Y = c(rep(-1,200), rep(+1,200))
# plot(X, col=Y+2, pch=20, cex=3, cex.axis=2)
# 
# model = build_classifier(X, Y, train.size=0.5, quantile.percentage=1, 
#		min.points=10, gamma.length=15, cost=10000)
# result = apply_classifier(model, X)
# points(X, col=as.numeric(result$classification.ensembled)+2, pch=20, cex=1.5)
# 
# x = seq(min(X), max(X), length=100)
# z = outer(x, x, function(x,y) { 
#	apply_classifier(model, as.matrix(cbind(x,y)))$classification.ensembled } )
# filled.contour(x,x,z)
# 
# x = seq(min(X), max(X), length=100)
# z = outer(x, x, function(x,y) { 
#	apply_classifier(model, as.matrix(cbind(x,y)), 
#		only.best.classifiers=TRUE)$classification.ensembled } )
# locator(1)
# filled.contour(x,x,z)
}
\keyword{analysis}
\keyword{coefficient}
\keyword{complexity}
\keyword{dataset}
\keyword{for}
\keyword{of}
\keyword{shattering}
\keyword{some}
\keyword{the}
