% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MutationProfiling.R
\name{calcObservedMutations}
\alias{calcObservedMutations}
\title{Count the number of observed mutations in a sequence.}
\usage{
calcObservedMutations(inputSeq, germlineSeq, frequency = FALSE,
  regionDefinition = NULL, mutationDefinition = NULL)
}
\arguments{
\item{inputSeq}{input sequence.}

\item{germlineSeq}{germline sequence.}

\item{frequency}{\code{logical} indicating whether or not to calculate
mutation frequencies. Default is \code{FALSE}.}

\item{regionDefinition}{\link{RegionDefinition} object defining the regions
and boundaries of the Ig sequences. Note, only the part of
sequences defined in \code{regionDefinition} are analyzed.
If NULL, mutations are counted for entire sequence.}

\item{mutationDefinition}{\link{MutationDefinition} object defining replacement
and silent mutation criteria. If \code{NULL} then 
replacement and silent are determined by exact 
amino acid identity.}
}
\value{
An \code{array} of the mutations, replacement (R) or silent(S), with the 
          names indicating the nucleotide postion of the mutations in the sequence.
}
\description{
\code{calcObservedMutations} determines all the mutations in a given input seqeunce compared
to its germline sequence.
}
\details{
Each mutation is considered independently in its codon context. Note, only the part of 
\code{inputSeq} defined in \code{regionDefinition} is analyzed. For example, when using 
the default \link{IMGT_V_NO_CDR3} definition, then mutations in positions beyond 
312 will be ignored.
}
\examples{
# Use first entry in the exampled data for input and germline sequence
data(ExampleDb, package="alakazam")
in_seq <- ExampleDb[1, "SEQUENCE_IMGT"]
germ_seq <-  ExampleDb[1, "GERMLINE_IMGT_D_MASK"]

# Identify all mutations in the sequence
calcObservedMutations(in_seq, germ_seq)

# Identify only mutations the V segment minus CDR3
calcObservedMutations(in_seq, germ_seq, regionDefinition=IMGT_V_NO_CDR3)
 
# Identify mutations by change in hydropathy class
calcObservedMutations(in_seq, germ_seq, regionDefinition=IMGT_V_NO_CDR3,
                      mutationDefinition=HYDROPATHY_MUTATIONS, frequency=TRUE)

}
\seealso{
See \link{observedMutations} for counting the number of observed mutations.
}

