% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/app.R
\name{gui}
\alias{gui}
\title{Run filtering panel locally}
\usage{
gui(
  cohort,
  steps = TRUE,
  stats = c("pre", "post"),
  run_button = FALSE,
  feedback = TRUE,
  state = TRUE,
  bootstrap = 3,
  enable_bookmarking = TRUE,
  code = TRUE,
  attrition = TRUE,
  show_help = TRUE,
  new_step = c("clone", "configure")
)
}
\arguments{
\item{cohort}{Cohort object with configured filters.}

\item{steps}{Set to TRUE (default) if multiple steps should be available.}

\item{stats}{Choose which statistics should be displayed for data (and some filters).
Possible options are: "pre" - previous step stat, "post" - current step stats,
`c("pre", "post")` - for both and NULL for no stats.}

\item{run_button}{Should Run button be displayed? If so, the current step computations are run only when clicked.}

\item{feedback}{Set to TRUE (default) if feedback plots should be displayed at each filter.}

\item{state}{Set to TRUE (default) to enable get/set state panel.}

\item{bootstrap}{Boostrap version to be used for filtering panel.
See \link[bslib]{bs_theme} version argument.}

\item{enable_bookmarking}{Set to TRUE (default) if panel should be compatible with native shiny bookmarking.}

\item{code}{Set to TRUE (default) to enable reproducible code panel.}

\item{attrition}{Set to TRUE (default) to enable attrition plot panel.}

\item{show_help}{Set to TRUE (default) to enable help buttons.}

\item{new_step}{Choose which add step method should be used for creating new step.
Possible options are: "clone" - copy filters from last step,
"configure" - opening modal and allow to chose filters from available filters.}
}
\value{
No return value, used for side effect which is running a Shiny application.
}
\description{
Run filtering panel locally
}
\examples{
if (interactive()) {
  library(magrittr)
  library(cohortBuilder)
  library(shinyCohortBuilder)
  mtcars_source <- set_source(tblist(mtcars = mtcars))
  mtcars_cohort <- cohort(
    mtcars_source,
    filter("discrete", id = "am", dataset = "mtcars", variable = "am", value = 1)
  ) \%>\% run()
  gui(mtcars_cohort)
}

}
