% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_eventlog.R
\name{read_eventlog}
\alias{read_eventlog}
\title{Reading eventlog}
\usage{
read_eventlog(file = NULL, db = NULL, last_n = Inf, verbose = TRUE)
}
\arguments{
\item{file}{A character string. Path to a file log.}

\item{db}{A character string. Connection string to a mongo database.}

\item{last_n}{An integer. How many last event records should be return?
Default is \code{Inf} which returns the whole eventlog.}

\item{verbose}{A logical value. Should the function print addition messages?
Default is TRUE.}
}
\value{
An object of class \code{eventlog} which is a data frame with
appropriate case, activity and timestamp classifiers specified.
The \code{eventlog} object is a result of
\code{\link[bupaR:eventlog]{bupaR:eventlog}} function from \code{bupaR}
package and it is suitable for further process-mining analysis.
}
\description{
\code{read_eventlog} reads eventlog stored in a file or in a database.
}
\examples{
read_eventlog(
 last_n = 25,
 file = system.file("shiny", "demoapp/events.log",
                     package = "shinyEventLogger"))
}
\seealso{
\code{\link{purge_eventlog}},
  \code{\link{run_demo}}.
}
