% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conditionalJS.R
\name{js_calls}
\alias{js_calls}
\alias{attachClass}
\alias{disable}
\alias{show}
\alias{css}
\alias{animateVisibility}
\alias{custom}
\title{JavaScript calls for conditionalJS}
\usage{
attachClass(class, when = TRUE)

disable(when = TRUE)

show(when = TRUE)

css(..., important = FALSE, when = TRUE)

animateVisibility(
  effectShow = "fadeIn",
  effectHide = "fadeOut",
  delay = 0,
  duration = 500,
  ignoreInit = TRUE,
  when = TRUE
)

custom(true = NULL, false = NULL)
}
\arguments{
\item{class}{A css to be attached to (or detached from) the UI element.}

\item{when}{Should the (primary) action be executed when `condition` is
TRUE (when = TRUE, default) or FALSE (when = FALSE).}

\item{...}{Named style properties, where the name is the property name and the
argument is the property value. See \link[htmltools]{css} for more details.}

\item{important}{Should `!important` rule be attached to the added css?}

\item{effectShow, effectHide}{Animation effects used for showing and hiding element.
Check \link{.cssEffects} object for possible options.}

\item{delay}{Delay of animation start (in milliseconds).}

\item{duration}{Duration of animation (in milliseconds).}

\item{ignoreInit}{Should the animation be skipped when application is in initial state?}

\item{true, false}{JS callback that should be executed when condition is true or false.
Can be custom JS (wrapped into \link[htmlwidgets]{JS}) or one of the \link{custom-callbacks}.}
}
\description{
The list of JavaScript calls that can be used as a `jsCall` argument of \link{conditionalJS}.
All the actions are reversible. E.g. when using `disable` call and conditionalJS condition is false
the opposite action to disable is called (removing disable attribute).
}
\details{
The currently offered actions:
\itemize{
  \item{attachClass}{ Add provided class to the UI element.}
  \item{disable}{ Add disable attribute to the UI element - usually results with disabling the input controller.}
  \item{show}{ Show/hide an element with a help of `visibility:hidden` rule.
    Comparing to conditionalPanel (which uses display:none) results with rendering an output even if hidden.}
  \item{css}{ Add css (inline) rule to the UI object. When condition is false, the rule is removed.}
  \item{animateVisibility}{ Show/hide an element in an animated way.}
  \item{custom}{ Define custom true and false callback.}
}
}
