% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7Card.R
\name{f7SocialCard}
\alias{f7SocialCard}
\title{Create a Framework7 social card}
\usage{
f7SocialCard(..., author_img = NULL, author = NULL, date = NULL, footer = NULL)
}
\arguments{
\item{...}{Card content.}

\item{author_img}{Author img.}

\item{author}{Author.}

\item{date}{Date.}

\item{footer}{Footer content, if any. Must be wrapped in a tagList.}
}
\description{
Build a Framework7 social card
}
\examples{
if(interactive()){
 library(shiny)
 library(shinyMobile)

 shiny::shinyApp(
  ui = f7Page(
    title = "Social Card",
    f7SingleLayout(
     navbar = f7Navbar(title = "f7SocialCard"),
     f7SocialCard(
     author_img = "http://lorempixel.com/68/68/people/1/",
     author = "John Doe",
     date = "Monday at 3:47 PM",
     "What a nice photo i took yesterday!",
     img(src = "http://lorempixel.com/1000/700/nature/8/", width = "100\%"),
     footer = tagList(
      f7Badge("1", color = "yellow"),
      f7Badge("2", color = "green"),
      f7Badge("3", color = "blue")
     )
    )
    )
  ),
  server = function(input, output) {}
 )
}

}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
