% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7TapHold.R
\name{f7TapHold}
\alias{f7TapHold}
\title{Create a Framework7 tapHold event}
\usage{
f7TapHold(target, callback, session)
}
\arguments{
\item{target}{Element to apply the tapHold event on. Must be a jQuery selector,
such as "#id" or ".class", ".class1, .class2", "a"...}

\item{callback}{Javascript callback.}

\item{session}{Shiny session object.}
}
\description{
Triggered after long press on an element.
}
\examples{
if (interactive()) {
library(shiny)
library(shinyMobile)

 shinyApp(
   ui = f7Page(
     title = "My app",
     f7SingleLayout(
       navbar = f7Navbar(title = "f7TapHold"),
       f7Button(inputId = "pressme", label = "Press me")
     )
   ),
   server = function(input, output, session) {
    observe({
      f7TapHold(
       target = "#pressme",
       callback = "app.dialog.alert('Tap hold fired!');",
       session = session
      )
    })
   }
 )
}
}
