% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7Timeline.R
\name{f7Timeline}
\alias{f7Timeline}
\title{Create a Framework7 timeline}
\usage{
f7Timeline(
  ...,
  sides = FALSE,
  horizontal = FALSE,
  calendar = FALSE,
  year = NULL,
  month = NULL
)
}
\arguments{
\item{...}{Slot for \link{f7TimelineItem}.}

\item{sides}{Enable side-by-side timeline mode.}

\item{horizontal}{Whether to use the horizontal layout. Not compatible with sides.}

\item{calendar}{Special type of horizontal layout with current year and month.}

\item{year}{Current year, only if calendar is TRUE.}

\item{month}{Current month, only if calendar is TRUE.}
}
\description{
Build a Framework7 timeline
}
\examples{
if(interactive()){
 library(shiny)
 library(shinyMobile)

 items <- tagList(
   f7TimelineItem(
     "Another text",
     date = "01 Dec",
     card = FALSE,
     time = "12:30",
     title = "Title",
     subtitle = "Subtitle",
     side = "left"
   ),
   f7TimelineItem(
     "Another text",
     date = "02 Dec",
     card = TRUE,
     time = "13:00",
     title = "Title",
     subtitle = "Subtitle"
   ),
   f7TimelineItem(
     "Another text",
     date = "03 Dec",
     card = FALSE,
     time = "14:45",
     title = "Title",
     subtitle = "Subtitle"
   )
 )

 shiny::shinyApp(
   ui = f7Page(
     title = "Timelines",
     f7SingleLayout(
       navbar = f7Navbar(title = "Timelines"),
       f7BlockTitle(title = "Horizontal timeline", size = "large") \%>\%
       f7Align(side = "center"),
       f7Timeline(
         sides = FALSE,
         horizontal = TRUE,
         items
       ),
       f7BlockTitle(title = "Vertical side by side timeline", size = "large") \%>\%
       f7Align(side = "center"),
       f7Timeline(
         sides = TRUE,
         items
       ),
       f7BlockTitle(title = "Vertical timeline", size = "large") \%>\%
       f7Align(side = "center"),
       f7Timeline(items),
       f7BlockTitle(title = "Calendar timeline", size = "large") \%>\%
       f7Align(side = "center"),
       f7Timeline(items, calendar = TRUE, year = "2019", month = "December")
     )
   ),
   server = function(input, output) {}
 )
}

}
\author{
David Granjon and Isabelle Rudolf, \email{dgranjon@ymail.com}
}
