% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7Progress.R
\name{f7Progress}
\alias{f7Progress}
\title{Create a Framework7 progress bar}
\usage{
f7Progress(id, value, color)
}
\arguments{
\item{id}{Progress id. Must be unique.}

\item{value}{Progress value. Between 0 and 100.}

\item{color}{Progress color. See \url{http://framework7.io/docs/progressbar.html}.}
}
\description{
Build a Framework7 progress bar
}
\examples{
if(interactive()){
 library(shiny)
 library(shinyMobile)

 shiny::shinyApp(
   ui = f7Page(
    title = "Progress",
    f7SingleLayout(
     navbar = f7Navbar(title = "f7Progress"),
     f7Block(
     f7Progress(id = "pg1", value = 10, color = "pink"),
     f7Progress(id = "pg2", value = 100, color = "green"),
     f7Progress(id = "pg3", value = 50, color = "orange")
    )
    )
   ),
   server = function(input, output) {}
 )
}

}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
