% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7Progress.R
\name{updateF7Progress}
\alias{updateF7Progress}
\title{update a framework7 progress bar from the server side}
\usage{
updateF7Progress(session, id, value)
}
\arguments{
\item{session}{Shiny session object.}

\item{id}{Unique progress bar id.}

\item{value}{New value.}
}
\description{
update a framework7 progress bar from the server side
}
\examples{
if (interactive()) {
 library(shiny)
 library(shinyMobile)

 shiny::shinyApp(
   ui = f7Page(
     title = "Progress",
     f7SingleLayout(
       navbar = f7Navbar(title = "f7Progress"),
       f7Block(
         f7Progress(id = "pg1", value = 10, color = "blue")
       ),
       f7Slider(
         inputId = "obs",
         label = "Progress value",
         max = 100,
         min = 0,
         value = 50,
         scale = TRUE
       )
     )
   ),
   server = function(input, output, session) {
     observeEvent(input$obs, {
       updateF7Progress(session, id = "pg1", value = input$obs)
     })
   }
 )
}
}
