% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7Notif.R
\name{f7Notif}
\alias{f7Notif}
\title{Framework7 notification}
\usage{
f7Notif(
  text,
  icon = NULL,
  title = NULL,
  titleRightText = NULL,
  subtitle = NULL,
  closeTimeout = 5000,
  closeButton = FALSE,
  closeOnClick = TRUE,
  swipeToClose = TRUE,
  ...,
  session = shiny::getDefaultReactiveDomain()
)
}
\arguments{
\item{text}{Notification content.}

\item{icon}{Notification icon.}

\item{title}{Notification title.}

\item{titleRightText}{Notification right text.}

\item{subtitle}{Notification subtitle}

\item{closeTimeout}{Time before notification closes.}

\item{closeButton}{Whether to display a close button.
FALSE by default.}

\item{closeOnClick}{Whether to close the notification on click. TRUE by default.}

\item{swipeToClose}{If enabled, notification can be closed by swipe gesture.}

\item{...}{Other options. See \url{https://framework7.io/docs/notification.html}.}

\item{session}{shiny session.}
}
\description{
Notification with title, text, icon and more.
}
\examples{
if (interactive()) {
  library(shiny)
  library(shinyMobile)
  shinyApp(
    ui = f7Page(
      title = "My app",
      f7SingleLayout(
        navbar = f7Navbar(title = "f7Notif"),
        f7Button(inputId = "goButton", "Go!")
      )
    ),
    server = function(input, output, session) {
      observeEvent(input$goButton,{
        f7Notif(
          text = "test",
          icon = f7Icon("bolt_fill"),
          title = "Notification",
          subtitle = "A subtitle",
          titleRightText = "now"
        )
      })
    }
  )
}
}
