% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7-inputs.R
\name{f7AutoComplete}
\alias{f7AutoComplete}
\alias{updateF7AutoComplete}
\title{Framework7 autocomplete input}
\usage{
f7AutoComplete(
  inputId,
  label = NULL,
  placeholder = NULL,
  value = NULL,
  choices,
  openIn = c("popup", "page", "dropdown"),
  typeahead = TRUE,
  expandInput = deprecated(),
  closeOnSelect = FALSE,
  dropdownPlaceholderText = NULL,
  multiple = FALSE,
  limit = NULL,
  style = list(media = NULL, description = NULL, floating = FALSE, outline = FALSE),
  ...
)

updateF7AutoComplete(
  inputId,
  value = NULL,
  choices = NULL,
  ...,
  session = shiny::getDefaultReactiveDomain()
)
}
\arguments{
\item{inputId}{Autocomplete input id.}

\item{label}{Autocomplete label.}

\item{placeholder}{Text to write in the container.}

\item{value}{Autocomplete initial value, if any.}

\item{choices}{Autocomplete choices.}

\item{openIn}{Defines how to open Autocomplete,
can be page or popup (for Standalone) or dropdown.}

\item{typeahead}{Enables type ahead, will prefill input
value with first item in match. Only if openIn is "dropdown".}

\item{expandInput}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}:
removed from Framework7.}

\item{closeOnSelect}{Set to true and autocomplete will be closed when user picks value.
Not available if multiple is enabled. Only works
when openIn is 'popup' or 'page'.}

\item{dropdownPlaceholderText}{Specify dropdown placeholder text.
Only if openIn is "dropdown".}

\item{multiple}{Whether to allow multiple value selection. Only works
when openIn is 'popup' or 'page'.}

\item{limit}{Limit number of maximum displayed items in autocomplete per query.}

\item{style}{Autocomplete styling parameters.
Only available when \code{openIn} is "dropdown".}

\item{...}{Extra options.
See \url{https://framework7.io/docs/autocomplete#autocomplete-parameters}}

\item{session}{The Shiny session object.}
}
\description{
\code{f7AutoComplete} generates a Framework7 autocomplete input.

\code{updateF7AutoComplete} changes the value of an autocomplete input on the client.
}
\note{
Contrary to \link{f7Text}, this input can't be cleared.
}
\examples{
library(shiny)
library(shinyMobile)

app <- shinyApp(
  ui = f7Page(
    title = "My app",
    f7SingleLayout(
      navbar = f7Navbar(title = "Update autocomplete"),
      f7Block(f7Button(inputId = "update", label = "Update autocomplete")),
      f7Block(
        inset = TRUE,
        strong = TRUE,
        f7BlockTitle("Autocomplete input"),
        f7AutoComplete(
          inputId = "myautocomplete",
          placeholder = "Some text here!",
          openIn = "dropdown",
          label = "Type a fruit name",
          choices = c(
            "Apple", "Apricot", "Avocado", "Banana", "Melon",
            "Orange", "Peach", "Pear", "Pineapple"
          ),
          style = list(
            outline = TRUE,
            media = f7Icon("house"),
            description = "typeahead input",
            floating = TRUE
          )
        )
      ),
      f7Block(verbatimTextOutput("autocompleteval"))
    )
  ),
  server = function(input, output, session) {
    output$autocompleteval <- renderText(input$myautocomplete)

    observeEvent(input$update, {
      updateF7AutoComplete(
        inputId = "myautocomplete",
        value = "plip",
        choices = c("plip", "plap", "ploup")
      )
    })
  }
)

if (interactive() || identical(Sys.getenv("TESTTHAT"), "true")) app
}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
