% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sweetalert.R
\name{confirmSweetAlert}
\alias{confirmSweetAlert}
\title{Launch a confirmation dialog}
\usage{
confirmSweetAlert(session, inputId, title = NULL, text = NULL,
  type = NULL, danger_mode = FALSE, btn_labels = c("Cancel",
  "Confirm"), closeOnClickOutside = FALSE, html = FALSE)
}
\arguments{
\item{session}{The \code{session} object passed to function given to shinyServer.}

\item{inputId}{The \code{input} slot that will be used to access the value.}

\item{title}{Title of the alert.}

\item{text}{Text of the alert, can contains HTML tags.}

\item{type}{Type of the alert : info, success, warning or error.}

\item{danger_mode}{Logical, activate danger mode (focus on cancel button).}

\item{btn_labels}{Labels for buttons.}

\item{closeOnClickOutside}{Decide whether the user should be able to dismiss
the modal by clicking outside of it, or not.}

\item{html}{Does \code{text} contains HTML tags ?}
}
\description{
Launch a popup to ask confirmation to the user
}
\examples{

\dontrun{

if (interactive()) {

library("shiny")
library("shinyWidgets")


ui <- fluidPage(
  tags$h1("Confirm sweet alert"),
  actionButton(
    inputId = "launch",
    label = "Launch confirmation dialog"
  ),
  verbatimTextOutput(outputId = "res"),
  uiOutput(outputId = "count")
)

server <- function(input, output, session) {
  # Launch sweet alert confirmation
  observeEvent(input$launch, {
    confirmSweetAlert(
      session = session,
      inputId = "myconfirmation",
      type = "warning",
      title = "Want to confirm ?",
      danger_mode = TRUE
    )
  })

  # raw output
  output$res <- renderPrint(input$myconfirmation)

  # count click
  true <- reactiveVal(0)
  false <- reactiveVal(0)
  observeEvent(input$myconfirmation, {
    if (isTRUE(input$myconfirmation)) {
      x <- true() + 1
      true(x)
    } else {
      x <- false() + 1
      false(x)
    }
  }, ignoreNULL = TRUE)
  output$count <- renderUI({
    tags$span(
      "Confirm:", tags$b(true()),
      tags$br(),
      "Cancel:", tags$b(false())
    )
  })
}

shinyApp(ui, server)




# other options :

ui <- fluidPage(
  tags$h1("Confirm sweet alert"),
  actionButton(
    inputId = "launch1",
    label = "Launch confirmation dialog (with danger mode)"
  ),
  verbatimTextOutput(outputId = "res1"),
  tags$br(),
  actionButton(
    inputId = "launch2",
    label = "Launch confirmation dialog (with normal mode)"
  ),
  verbatimTextOutput(outputId = "res2"),
  tags$br(),
  actionButton(
    inputId = "launch3",
    label = "Launch confirmation dialog (with HTML)"
  ),
  verbatimTextOutput(outputId = "res3")
)

server <- function(input, output, session) {

  observeEvent(input$launch1, {
    confirmSweetAlert(
      session = session,
      inputId = "myconfirmation1",
      type = "warning",
      title = "Want to confirm ?",
      danger_mode = TRUE
    )
  })
  output$res1 <- renderPrint(input$myconfirmation1)

  observeEvent(input$launch2, {
    confirmSweetAlert(
      session = session,
      inputId = "myconfirmation2",
      type = "warning",
      title = "Are you sure ??",
      btn_labels = c("Nope", "Yep"),
      danger_mode = FALSE
    )
  })
  output$res2 <- renderPrint(input$myconfirmation2)

  observeEvent(input$launch3, {
    confirmSweetAlert(
      session = session,
      inputId = "myconfirmation3",
      title = NULL,
      text = tags$b(
        icon("file"),
        "Do you really want to delete this file ?",
        style = "color: #FA5858;"
      ),
      btn_labels = c("Cancel", "Delete file"),
      danger_mode = TRUE, html = TRUE
    )
  })
  output$res3 <- renderPrint(input$myconfirmation3)

}

shinyApp(ui = ui, server = server)

}

}
}
\seealso{
\code{\link{sendSweetAlert}}, \code{\link{inputSweetAlert}}
}
