% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dashboardPagePlus.R
\name{dashboardPagePlus}
\alias{dashboardPagePlus}
\title{Dashboard Page with a right sidebar}
\usage{
dashboardPagePlus(header, sidebar, body, rightsidebar = NULL, title = NULL,
  skin = c("blue", "blue-light", "black", "black-light", "purple",
  "purple-light", "green", "green-light", "red", "red-light", "yellow",
  "yellow-light"), collapse_sidebar = FALSE)
}
\arguments{
\item{header}{A header created by \code{dashboardHeaderPlus}.}

\item{sidebar}{A sidebar created by \code{dashboardSidebar}.}

\item{body}{A body created by \code{dashboardBody}.}

\item{rightsidebar}{A right sidebar created by \code{rightSidebar}. NULL by default.}

\item{title}{A title to display in the browser's title bar. If no value is
provided, it will try to extract the title from the \code{dashboardHeaderPlus}.}

\item{skin}{A color theme. One of \code{"blue"}, \code{"black"},
\code{"purple"}, \code{"green"}, \code{"red"}, or \code{"yellow"}.}

\item{collapse_sidebar}{Whether to collapse the left sidebar. TRUE by default.}
}
\description{
This creates a dashboard page for use in a Shiny app.
}
\examples{
if (interactive()) {
library(shiny)
shinyApp(
  ui = dashboardPagePlus(
    header = dashboardHeaderPlus(
     enable_rightsidebar = TRUE,
     rightSidebarIcon = "gears"
    ),
    sidebar = dashboardSidebar(),
    body = dashboardBody(),
    rightsidebar = rightSidebar(),
    title = "DashboardPage"
  ),
  server = function(input, output) { }
)
}
}
\seealso{
\code{\link{dashboardHeaderPlus}}, \code{\link{dashboardSidebar}},
  \code{\link{dashboardBody}}.
}
