% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_series.R
\name{draw_sig_activity}
\alias{draw_sig_activity}
\title{Plot signature activity}
\usage{
draw_sig_activity(nmfObj, mode = c("copynumber", "mutation"),
  font_scale = 1, hide_samps = TRUE)
}
\arguments{
\item{nmfObj}{a \code{NMF} result object which is an element return from \link{sig_extract}
or run results of \strong{NMF} package.}

\item{mode}{variation type to decompose, currently support "copynumber" or "mutation".}

\item{font_scale}{a number used to set font scale.}

\item{hide_samps}{if \code{TRUE}, not show sample names.}
}
\value{
a \code{ggplot} object
}
\description{
Currently support copy number signatures and mutational signatures.
}
\examples{
# Load copy number signature
load(system.file("extdata", "toy_copynumber_signature.RData",
  package = "sigminer", mustWork = TRUE
))
draw_sig_activity(res$nmfObj)
}
\seealso{
Other signature plot: \code{\link{draw_sig_corrplot}},
  \code{\link{draw_sig_profile}},
  \code{\link{draw_subtypes_comparison}}
}
\author{
Shixiang Wang
}
\concept{signature plot}
