% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_cn_distribution.R
\name{show_cn_distribution}
\alias{show_cn_distribution}
\title{Show Copy Number Distribution either by Length or Chromosome}
\usage{
show_cn_distribution(
  data,
  rm_normal = TRUE,
  mode = c("ld", "cd"),
  fill = FALSE,
  scale_chr = TRUE,
  base_size = 14
)
}
\arguments{
\item{data}{a \link{CopyNumber} object.}

\item{rm_normal}{logical. Whether remove normal copy (i.e. "segVal" equals 2), default is \code{TRUE}.}

\item{mode}{either "ld" for distribution by CN length or "cd" for distribution by chromosome.}

\item{fill}{when \code{mode} is "cd" and \code{fill} is \code{TRUE}, plot percentage instead of count.}

\item{scale_chr}{logical. If \code{TRUE}, normalize count to per Megabase unit.}

\item{base_size}{overall font size.}
}
\value{
a \code{ggplot} object
}
\description{
Visually summarize copy number distribution either by copy number segment length
or chromosome. Input is a \link{CopyNumber} object, \code{genome_build} option will
read from \code{genome_build} slot of object.
}
\examples{
# Load copy number object
load(system.file("extdata", "toy_copynumber.RData",
  package = "sigminer", mustWork = TRUE
))
# Plot distribution
p1 <- show_cn_distribution(cn)
p1
p2 <- show_cn_distribution(cn, mode = "cd")
p2
p3 <- show_cn_distribution(cn, mode = "cd", fill = TRUE)
p3
}
\author{
Shixiang Wang \href{mailto:w_shixiang@163.com}{w_shixiang@163.com}
}
